<?xml version="1.0" encoding="UTF-8"?><!--
            Copyright
            2010 axYus - http://www.axyus.com
            2010 J.Leger - johann.leger@axyus.com

            This file is part of ODM print-comp.

            ODM print-comp is free software; you can redistribute it and/or modify
            it under the terms of the GNU Lesser General Public License as published by
            the Free Software Foundation; either version 2 of the License, or
            (at your option) any later version.

            ODM print-comp is distributed in the hope that it will be useful,
            but WITHOUT ANY WARRANTY; without even the implied warranty of
            MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
            GNU Lesser General Public License for more details.

            You should have received a copy of the GNU Lesser General Public License
            along with ODM print-comp; if not, write to the Free Software
            Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
        --><xsl:stylesheet xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:data="http://odm-budgetaire.org/data" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:date="http://exslt.org/dates-and-times" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:com="http://www.xemelios.org/namespaces#cg-1.0" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../../../number.xsl"></xsl:import><xsl:import href="../../../../date.xsl"></xsl:import><xsl:import href="../../../../table.xsl"></xsl:import><xsl:import href="../../../../style.xsl"></xsl:import><xsl:import href="../../../../lien.xsl"></xsl:import><xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"></xsl:variable><xsl:param name="nomenclaturePasEnrichie"></xsl:param><xsl:variable name="nomenclature" select="$nomenclaturePasEnrichie/n:Nomenclature"></xsl:variable><xsl:variable name="data" select="document('../../libelleAffiche.xml')/data"></xsl:variable><xsl:variable name="isPrint" select="1"></xsl:variable><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="*"></xsl:template><xsl:template match="dcfu:CompteFinancierUnique"><html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
   <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /><meta name="generator" content="ODM" />
      
      <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
      <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
      
      <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:SimSun;
  panose-1:2 1 6 0 3 1 1 1 1 1;}
@font-face
  {font-family:Mangal;
  panose-1:0 0 4 0 0 0 0 0 0 0;}
@font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:Cambria;
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:"\@SimSun";
  panose-1:2 1 6 0 3 1 1 1 1 1;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0cm;
  margin-bottom:.0001pt;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
@page{size:297mm 210mm;
  }
div.WordSection1
  {}
--&gt;
/**/
}</style></head>
   <body lang="FR">
      <div class="WordSection1">
         <p class="MsoNormal" align="center" style="margin-top:3.65pt;margin-right:1.5pt; margin-bottom:0cm;margin-left:0cm;margin-bottom:.0001pt;text-align:center"><xsl:variable name ="Refer1">PAGGARD</xsl:variable><xsl:variable name ="Refer2" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Refer3" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="lien:reference"><xsl:with-param name="id" select="concat ($Refer1, '_', $Refer2, '_', $Refer3)"/></xsl:call-template><b><span style="font-size:14.0pt">RÉPUBLIQUE FRANÇAISE</span></b></p>
         <p class="MsoNormal"> </p>
         <p class="MsoNormal"> </p>
         <xsl:variable name="varOdmTmpTab1"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0"><tr><td width="100%" valign="top" style="border:solid black 1.0pt; padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1"><p align="center" style="margin-top:3.2pt;text-align:center"><span style="font-size:14.0pt"><xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Libelle)"/></span></p><xsl:variable name="varOdmTmpTab2"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><xsl:choose><xsl:when test="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@TypeBC = 'BA' or $docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@TypeBC = 'BR'"><xsl:variable name="varOdm1" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="center" style="margin-top:3.2pt;text-align:center"><span style="font-size:12.0pt">RELATIF AU BUDGET PRINCIPAL DE <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:BudgetRattachement/@Libelle)"/></span></p></td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:otherwise></xsl:choose></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param></xsl:call-template></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"> </p>
         <p class="MsoNormal"> </p>
         <p class="MsoNormal" align="center" style="text-align:center">Numéro SIRET : <xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:with-param name="format" select="&quot;#0&quot;"/></xsl:call-template></p>
         <p class="MsoNormal" align="center" style="text-align:center"> </p>
         <p class="MsoNormal" align="center" style="text-align:center">POSTE COMPTABLE : <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Tresorerie/@Codique)"/> <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Tresorerie/@LibellePoste)"/></p>
         <p class="MsoNormal"> </p>
         <p class="MsoNormal"> </p>
         <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:14.0pt">Compte financier unique (<xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Nomenclature/@V)"/>)</span></b></p>
         <p class="MsoNormal"> </p>
         <p class="MsoNormal"><b><span style="font-size:14.0pt"> </span></b></p>
         <xsl:variable name="varOdmTmpTab3"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><xsl:choose><xsl:when test="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:NatFonc/@V = '1' or $docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:NatFonc/@V = '3'"><xsl:variable name="varOdm2" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                  <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:14.0pt"> Voté par Nature</span></b></p>
               </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:NatFonc/@V = '2'"><xsl:variable name="varOdm3" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                  <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:14.0pt"> Voté par Fonction</span></b></p>
               </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@TypeBC = 'BP'"><xsl:variable name="varOdm4" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                  <p class="MsoNormal" align="center" style="text-align:center"><span style="font-size:14.0pt">BUDGET PRINCIPAL</span></p>
               </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@TypeBC = 'BA' or $docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@TypeBC = 'BR'"><xsl:variable name="varOdm5" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                  <p class="MsoNormal" align="center" style="text-align:center"><span style="font-size:14.0pt">BUDGET ANNEXE</span></p>
               </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:otherwise></xsl:choose></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab3"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"> </p>
         <p class="MsoNormal"> </p>
         <p class="MsoNormal" align="center" style="text-align:center;punctuation-wrap:simple"><span style="font-size:14.0pt">ANNEE <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V)"/></span></p>
         <p class="MsoNormal"><b><span style="font-family:&#34;Cambria&#34;,serif;color:#365F92"> </span></b></p>
         <p class="MsoNormal"> </p>
      </div>
   </body><script type="text/javascript">
            function iframeLoadPage(href) {
            try {
            parent.loadPage(href);
            } catch(ex) {
            //si on n'arrive pas a acceder a la page parente
            document.location.href = href;
            }
            }
            function scrollToElementId(elementId) {
            document.getElementById(elementId).scrollIntoView();
            }
        </script>
</html></xsl:template></xsl:stylesheet>